/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.components.popup.list;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.msdf.Font;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.framework.objects.MouseButton;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.ui.components.popup.Popup;
import Krasnodar.rockstarnew.ui.components.popup.PopupAction;
import Krasnodar.rockstarnew.ui.components.popup.PopupComponent;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.game.cursor.CursorType;
import Krasnodar.rockstarnew.utility.game.cursor.CursorUtility;
import Krasnodar.rockstarnew.utility.gui.GuiUtility;
import com.mojang.blaze3d.systems.RenderSystem;
import lombok.Generated;

public class Button
extends PopupComponent {
    private final Popup popup;
    private final String text;
    private final String icon;
    private PopupAction action;
    private final Animation hoverAnimation = new Animation(300L, Easing.FIGMA_EASE_IN_OUT);

    @Override
    protected void renderComponent(UIContext context) {
        Font nameFont = Fonts.REGULAR.getFont(8.0f);
        float nameLeftPadding = 8.0f;
        float nameHeight = nameFont.height();
        this.hoverAnimation.update(this.isHovered(context.getMouseX(), context.getMouseY()));
        if (this.isHovered(context.getMouseX(), context.getMouseY())) {
            CursorUtility.set(CursorType.HAND);
        }
        ColorRGBA color = !this.text.equals(Localizator.translate("remove")) ? Colors.getTextColor() : ColorRGBA.RED.mix(ColorRGBA.WHITE, 0.3f);
        context.drawFadeoutText(nameFont, this.text, this.x + nameLeftPadding, this.y + GuiUtility.getMiddleOfBox(nameHeight, this.height), color.withAlpha(RenderSystem.getShaderColor()[3] * 255.0f * (0.75f + 0.25f * this.hoverAnimation.getValue())), 0.8f, 1.0f, this.width - 24.0f);
        context.drawTexture(Rockstar.id(this.icon), this.x + this.width - 16.0f, this.y + 6.0f, 8.0f, 8.0f, color.withAlpha(RenderSystem.getShaderColor()[3] * 255.0f * (0.75f + 0.25f * this.hoverAnimation.getValue())));
        if (this.isHovered(context)) {
            CursorUtility.set(CursorType.HAND);
        }
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, MouseButton button) {
        if (this.isHovered(mouseX, mouseY) && button == MouseButton.LEFT) {
            this.action.run(this.popup);
        }
        super.onMouseClicked(mouseX, mouseY, button);
    }

    @Override
    public float getHeight() {
        this.height = 19.0f;
        return 19.0f;
    }

    @Generated
    public Button(Popup popup, String text, String icon, PopupAction action) {
        this.popup = popup;
        this.text = text;
        this.icon = icon;
        this.action = action;
    }
}

